<?php
// Tentukan folder untuk menyimpan file sementara
$uploadDir = 'uploads/';
// Tentukan durasi file akan disimpan (dalam detik)
$fileLifetime = 30; 

// Buat folder 'uploads' jika belum ada
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// --- FUNGSI UNTUK MENGHAPUS FILE LAMA ---
// Fungsi ini akan memeriksa dan menghapus file yang lebih tua dari $fileLifetime
function deleteOldFiles($dir, $lifetime) {
    if ($handle = opendir($dir)) {
        while (false !== ($file = readdir($handle))) {
            if ($file != "." && $file != "..") {
                $filePath = $dir . $file;
                // Jika waktu modifikasi file + masa aktif < waktu sekarang, hapus file
                if (filemtime($filePath) + $lifetime < time()) {
                    unlink($filePath);
                }
            }
        }
        closedir($handle);
    }
}

// Jalankan fungsi pembersihan setiap kali skrip diakses
deleteOldFiles($uploadDir, $fileLifetime);


// --- PROSES UPLOAD FILE ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['pdfFile'])) {
    
    // Cek jika ada error saat upload
    if ($_FILES['pdfFile']['error'] !== UPLOAD_ERR_OK) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Gagal saat mengunggah file. Kode Error: ' . $_FILES['pdfFile']['error']]);
        exit;
    }

    // Buat nama file yang unik untuk menghindari tumpang tindih
    $fileName = uniqid('laporan-', true) . '.pdf';
    $destination = $uploadDir . $fileName;

    // Pindahkan file yang di-upload ke folder tujuan
    if (move_uploaded_file($_FILES['pdfFile']['tmp_name'], $destination)) {
        // Berhasil! Kirim kembali URL file ke klien
        
        // Dapatkan protokol (http atau https)
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        // Dapatkan nama host (domain)
        $host = $_SERVER['HTTP_HOST'];
        // Dapatkan path skrip saat ini
        $scriptPath = dirname($_SERVER['PHP_SELF']);
        
        // Gabungkan untuk membuat URL lengkap ke file
        $fileUrl = $protocol . $host . $scriptPath . '/' . $destination;
        
        // Kirim response dalam format JSON
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'url' => $fileUrl]);
    } else {
        // Gagal memindahkan file
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Gagal menyimpan file di server.']);
    }
} else {
    // Jika bukan request POST atau tidak ada file
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Request tidak valid.']);
}
?>
